/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"
#include "lx_route_file.h"
#include "lx_xbar_file.h"

lx_t lx;

static void usage (char*s)
{
  fprintf (stderr, "usage: %s <map file> <xbar file> [iport]\n", s);
  exit (0);
}

static int print_port (FILE*fp, lx_map_t*m, lx_xbar_table_entry_t*entries, int xbar, int port)
{
  lx_node_t*n, *o;
  int op;
  
  insist (fp && m && entries);
  insist (xbar >= 0 && xbar < m->num_xbars);
  insist (port >= 0 && port < LX_XBAR_SIZE);
  
  n = m->xbar_array [xbar];
  insist (n && n->xbar && !n->first);
  
  if ((o = lx_get_node (n, port)))
  {
    op = lx_get_port (n, port);
    
    if (o->xbar)
    {
      insist (o->index < m->num_xbars);

      if (memcmp (entries [xbar].mac_address, entries [o->index].mac_address, 6))
      {
	fprintf (fp, "switch " lx_mac_format " xbar %d port %d", lx_mac_args (entries [n->index].mac_address), entries [n->index].xbar, port);
	fprintf (fp, " <---> ");
	fprintf (fp, "switch " lx_mac_format " xbar %d port %d", lx_mac_args (entries [o->index].mac_address), entries [o->index].xbar, op);
	fprintf (fp, "\n");
      }
    }
    else
    {
      insist (o->index < m->num_hosts);

      fprintf (fp, "switch " lx_mac_format " xbar %d port %d", lx_mac_args (entries [n->index].mac_address), entries [n->index].xbar, port);
      fprintf (fp, " <---> ");
      fprintf (fp, "host " lx_mac_format " port %d", lx_mac_args (lx_host_c (o)->mac_address), op);
      fprintf (fp, "\n");
    }
  }
  return 1;
  except: return 0;
}

int main (int argc, char*argv [])
{
  lx_map_t*m;
  FILE*fp;
  lx_node_t*first;
  int i, j, iport, num_read;
  lx_xbar_table_entry_t*entries;  

  mi_verbose_flag = 0;

  if (argc < 3)
    usage (argv [0]);
  
  if ((iport = (argc == 3 ? 0 : atoi (argv [3]))) < 0 || iport > MI_MY_SIZE)
    usage (argv [0]);
  
  if (!(fp = fopen (argv [1], "r")))
  {
    fprintf (stderr, "couldn't open %s\n", argv [1]);
    usage (argv [0]);
  }
  
  lx_init (&lx);
  
  if (!lx_map_file_read (fp, &lx.maps [0], &first))
  {
    fprintf (stderr, "lx_map_file_read () failed\n");
    return 0;
  }

  m = lx.maps;
  fprintf (stderr, "%d hosts and %d xbars\n", m->num_hosts, m->num_xbars);

  if (!m->num_xbars)
  {
    fprintf (stderr, "no xbars\n");
    return 0;
  }
  
  entries = (lx_xbar_table_entry_t*) malloc (sizeof (*entries) * m->num_xbars);
  insist (entries);
  
  if (!(fp = fopen (argv [2], "r")))
  {
    fprintf (stderr, "couldn't open %s\n", argv [2]);
    usage (argv [0]);
  }

  if ((num_read = lx_xbar_file_read_xbars (fp, m, iport, first, entries)) != m->num_xbars)
  {
    fprintf (stderr, "only %d entries read\n", num_read);
    usage (argv [0]);
  }
  
  for (i = 0; i < m->num_xbars; i++)
  {
    for (j = 0; j < LX_XBAR_SIZE; j++)
    {
      if (!print_port (stdout, m, entries, i, j))
	return 0;
    }
  }
  
  return 1;
  except: return 0;
}
